# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 168-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53732);
 script_cve_id("CVE-2002-0985", "CVE-2002-0986");
 script_bugtraq_id(5681);
 script_version ("$");
 name = "Debian Security Advisory DSA 168-1 (PHP3, PHP4)";
 script_name(name);

 desc = "The remote host is missing an update to PHP3, PHP4
announced via advisory DSA 168-1.

Wojciech Purczynski found out that it is possible for scripts to pass
arbitrary text to sendmail as commandline extension when sending a
mail through PHP even when safe_mode is turned on.  Passing 5th
argument should be disabled if PHP is configured in safe_mode, which
is the case for newer PHP versions and for the versions below.  This
does not affect PHP3, though.

Wojciech Purczynski also found out that arbitrary ASCII control
characters may be injected into string arguments of mail() function.
If mail() arguments are taken from user's input it may give the user
ability to alter message content including mail headers.

Ulf Harnhammar discovered that file() and fopen() are vulnerable to
CRLF injection.  An attacker could use it to escape certain
restrictions and add arbitrary text to alleged HTTP requests that are
passed through.

However this only happens if something is passed to these functions
which is neither a valid file name nor a valid url.  Any string that
contains control chars cannot be a valid url.  Before you pass a
string that should be an url to any function you must use urlencode()
to encode it.

Three problems have been identified in PHP:

1. The mail() function can allow arbitrary email headers to be
specified if a recipient address or subject contains CR/LF
characters.

2. The mail() function does not properly disable the passing of
arbitrary command-line options to sendmail when running in Safe
Mode.

3. The fopen() function, when retrieving a URL, can allow manipulation
of the request for the resource through a URL containing CR/LF
characters.  For example, headers could be added to an HTTP
request.

These problems have been fixed in version 3.0.18-23.1woody1 for PHP3
and 4.1.2-5 for PHP4 for the current stable distribution (woody), in
version 3.0.18-0potato1.2 for PHP3 and 4.0.3pl1-0potato4 for PHP4 in
the old stable distribution (potato) and in version 3.0.18-23.2 for
PHP3 and 4.2.3-3 for PHP4 for the unstable distribution (sid).

We recommend that you upgrade your PHP packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20168-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 168-1 (PHP3, PHP4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php3", ver:"3.0.18-0potato1.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi", ver:"3.0.18-0potato1.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.0.3pl1-0potato4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.0.3pl1-0potato4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3", ver:"3.0.18-23.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi", ver:"3.0.18-23.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"caudium-php4", ver:"4.1.2-5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.1.2-5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.1.2-5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
