# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1679-1 (awstats)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62841);
 script_cve_id("CVE-2008-3714");
 script_version ("$");
 name = "Debian Security Advisory DSA 1679-1 (awstats)";
 script_name(name);

 desc = "The remote host is missing an update to awstats
announced via advisory DSA 1679-1.

Morgan Todd discovered a cross-site scripting vulnerability in awstats,
a log file analyzer, involving the config request parameter (and
possibly others; CVE-2008-3714).

For the stable distribution (etch), this problem has been fixed in version
6.5+dfsg-1+etch1.

The unstable (sid) and testing (lenny) distribution will be fixed soon.

We recommend that you upgrade your awstats package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201679-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1679-1 (awstats)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"awstats", ver:"6.5+dfsg-1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
