# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1670-1 (enscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61933);
 script_cve_id("CVE-2008-3863", "CVE-2008-4306");
 script_version ("$");
 name = "Debian Security Advisory DSA 1670-1 (enscript)";
 script_name(name);

 desc = "The remote host is missing an update to enscript
announced via advisory DSA 1670-1.

Several vulnerabilities have been discovered in Enscript, a converter
from ASCII text to Postscript, HTML or RTF. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2008-3863

Ulf Harnhammer discovered that a buffer overflow may lead to
the execution of arbitrary code.

CVE-2008-4306

Kees Cook and Tomas Hoger discovered that several buffer
overflows may lead to the execution of arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 1.6.4-11.1.

For the upcoming stable distribution (lenny) and the unstable
distribution (sid), these problems have been fixed in version 1.6.4-13.

We recommend that you upgrade your enscript package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201670-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1670-1 (enscript)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"enscript", ver:"1.6.4-11.1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
