# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1576-1 (openssh)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61029);
 script_cve_id("CVE-2008-0166", "CVE-2008-1483", "CVE-2007-4752");
 script_version ("$");
 name = "Debian Security Advisory DSA 1576-1 (openssh)";
 script_name(name);

 desc = "The remote host is missing an update to openssh
announced via advisory DSA 1576-1.

The recently announced vulnerability in Debian's openssl package
(DSA-1571-1, CVE-2008-0166) indirectly affects OpenSSH.  As a result,
all user and host keys generated using broken versions of the openssl
package must be considered untrustworthy, even after the openssl update
has been applied.

For more information on how to correct and update your system
to correct for weak keys, please visit the referenced security
advisory.

For the stable distribution (etch), these problems have been fixed in
version 4.3p2-9etch1.  Currently, only a subset of all supported
architectures have been built; further updates will be provided when
they become available.

For the unstable distribution (sid) and the testing distribution
(lenny), these problems have been fixed in version 4.7p1-9.

We recommend that you upgrade your openssh packages and take the

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201576-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1576-1 (openssh)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openssh-blacklist", ver:"0.1.1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh", ver:"4.3p2-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.3p2-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssh-client", ver:"4.3p2-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.3p2-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssh-server", ver:"4.3p2-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
