# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1571-1 (openssl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61027);
 script_cve_id("CVE-2008-0166", "CVE-2007-4995", "CVE-2007-3108");
 script_version ("$");
 name = "Debian Security Advisory DSA 1571-1 (openssl)";
 script_name(name);

 desc = "The remote host is missing an update to openssl
announced via advisory DSA 1571-1.

Luciano Bello discovered that the random number generator in Debian's
openssl package is predictable.  This is caused by an incorrect
Debian-specific change to the openssl package (CVE-2008-0166).  As a
result, cryptographic key material may be guessable.

This is a Debian-specific vulnerability which does not affect other
operating systems which are not based on Debian.  However, other systems
can be indirectly affected if weak keys are imported into them.

It is strongly recommended that all cryptographic key material which has
been generated by OpenSSL versions starting with 0.9.8c-1 on Debian
systems is recreated from scratch.  Furthermore, all DSA keys ever used
on affected Debian systems for signing or authentication purposes should
be considered compromised; the Digital Signature Algorithm relies on a
secret random value used during signature generation.

The first vulnerable version, 0.9.8c-1, was uploaded to the unstable
distribution on 2006-09-17, and has since propagated to the testing and
current stable (etch) distributions.  The old stable distribution
(sarge) is not affected.

Affected keys include SSH keys, OpenVPN keys, DNSSEC keys, and key
material for use in X.509 certificates and session keys used in SSL/TLS
connections.  Keys generated with GnuPG or GNUTLS are not affected,
though.

A detector for known weak key material will be published at:

<http://security.debian.org/project/extra/dowkd/dowkd.pl.gz>
<http://security.debian.org/project/extra/dowkd/dowkd.pl.gz.asc>
(OpenPGP signature)

Instructions how to implement key rollover for various packages will be
published at:

<http://www.debian.org/security/key-rollover/>

This web site will be continously updated to reflect new and updated
instructions on key rollovers for packages using SSL certificates.
Popular packages not affected will also be listed.

In addition to this critical change, two other vulnerabilities have been
fixed in the openssl package which were originally scheduled for release
with the next etch point release: OpenSSL's DTLS (Datagram TLS,
basically SSL over UDP) implementation did not actually implement the
DTLS specification, but a potentially much weaker protocol, and
contained a vulnerability permitting arbitrary code execution
(CVE-2007-4995).  A side channel attack in the integer multiplication
routines is also addressed (CVE-2007-3108).

For the stable distribution (etch), these problems have been fixed in
version 0.9.8c-4etch3.

For the unstable distribution (sid) and the testing distribution
(lenny), these problems have been fixed in version 0.9.8g-9.

We recommend that you upgrade your openssl package and subsequently

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201571-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1571-1 (openssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
