# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1556-2 (perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60864);
 script_cve_id("CVE-2008-1927");
 script_version ("$");
 name = "Debian Security Advisory DSA 1556-2 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory DSA 1556-2.

An editorial mistake resulted in DSA-1556-1 not correctly applying the
required change, making it ineffective.  This DSA has been reissued as
DSA-1556-2.  We apologize for the inconvenience.  The text of the
original DSA follows.

It has been discovered that the Perl interpreter may encounter a buffer
overflow condition when compiling certain regular expressions containing
Unicode characters.  This also happens if the offending characters are
contained in a variable reference protected by the \Q...\E quoting
construct.  When encountering this condition, the Perl interpreter
typically crashes, but arbitrary code execution cannot be ruled out.

For the stable distribution (etch), this problem has been fixed in
version 5.8.8-7etch3.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your perl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201556-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1556-2 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.8-7etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
