# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1538-1 (alsaplayer)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60785);
 script_cve_id("CVE-2007-5301");
 script_version ("$");
 name = "Debian Security Advisory DSA 1538-1 (alsaplayer)";
 script_name(name);

 desc = "The remote host is missing an update to alsaplayer
announced via advisory DSA 1538-1.

Erik Sjlund discovered a buffer overflow vulnerability in the Ogg
Vorbis input plugin of the alsaplayer audio playback application.
Successful exploitation of this vulnerability through the opening of a
maliciously-crafted Vorbis file could lead to the execution of
arbitrary code.

For the stable distribution (etch), the problem has been fixed in
version 0.99.76-9+etch1.

For the unstable distribution (sid), the problem was fixed in version
0.99.80~rc4-1.

We recommend that you upgrade your alsaplayer packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201538-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1538-1 (alsaplayer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"alsaplayer-alsa", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-xosd", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-daemon", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-jack", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-oss", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-common", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-esd", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-nas", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-gtk", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libalsaplayer0", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libalsaplayer-dev", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsaplayer-text", ver:"0.99.76-9+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
