# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1496-1 (mplayer)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60371);
 script_cve_id("CVE-2008-0485", "CVE-2008-0486", "CVE-2008-0629", "CVE-2008-0630");
 script_version ("$");
 name = "Debian Security Advisory DSA 1496-1 (mplayer)";
 script_name(name);

 desc = "The remote host is missing an update to mplayer
announced via advisory DSA 1496-1.

Several buffer overflows have been discovered in the MPlayer movie player,
which might lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-0485

Felipe Manzano and Anibal Sacco discovered a buffer overflow in
the demuxer for MOV files.

CVE-2008-0486

Reimar Doeffinger discovered a buffer overflow in the FLAC header
parsing.

CVE-2008-0629

Adam Bozanich discovered a buffer overflow in the CDDB access code.

CVE-2008-0630

Adam Bozanich discovered a buffer overflow in URL parsing.


For the stable distribution (etch), these problems have been fixed in
version 1.0~rc1-12etch2.

The old stable distribution (sarge) doesn't contain mplayer.

We recommend that you upgrade your mplayer packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201496-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1496-1 (mplayer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mplayer-doc", ver:"1.0~rc1-12etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mplayer", ver:"1.0~rc1-12etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
