# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1473-1 (scponly)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60217);
 script_cve_id("CVE-2007-6350", "CVE-2007-6415");
 script_version ("$");
 name = "Debian Security Advisory DSA 1473-1 (scponly)";
 script_name(name);

 desc = "The remote host is missing an update to scponly
announced via advisory DSA 1473-1.

Joachim Breitner discovered that Subversion support in scponly is
inherently insecure, allowing execution of arbitrary commands.  Further
investigation showed that rsync and Unison support suffer from similar
issues.  This set of issues has been assigned CVE-2007-6350.

In addition, it was discovered that it was possible to invoke with scp
with certain options that may lead to execution of arbitrary commands
(CVE-2007-6415).

This update removes Subversion, rsync and Unison support from the
scponly package, and prevents scp from being invoked with the dangerous
options.

For the stable distribution (etch), these problems have been fixed in
version 4.6-1etch1.

For the old stable distribution (sarge), these problems have been fixed
in version 4.0-1sarge2.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your scponly package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201473-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1473-1 (scponly)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"scponly", ver:"4.0-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"scponly", ver:"4.6-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
