# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1455-1 (libarchive1)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60110);
 script_cve_id("CVE-2007-3641", "CVE-2007-3644", "CVE-2007-3645");
 script_version ("$");
 name = "Debian Security Advisory DSA 1455-1 (libarchive1)";
 script_name(name);

 desc = "The remote host is missing an update to libarchive1
announced via advisory DSA 1455-1.

Several local/remote vulnerabilities have been discovered in libarchive1,
a single library to read/write tar, cpio, pax, zip, iso9660, archives.

The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2007-3641

It was discovered that libarchive1 would miscompute the length of a buffer
resulting in a buffer overflow if yet another type of corruption occurred
in a pax extension header.

CVE-2007-3644

It was discovered that if an archive prematurely ended within a pax
extension header the libarchive1 library could enter an infinite loop.

CVE-2007-3645

If an archive prematurely ended within a tar header, immediately following
a pax extension header, libarchive1 could dereference a NULL pointer.


The old stable distribution (sarge), does not contain this package.

For the stable distribution (etch), these problems have been fixed in
version 1.2.53-2etch1.

For the unstable distribution (sid), these problems have been fixed in
version 2.2.4-1.

We recommend that you upgrade your libarchive package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201455-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1455-1 (libarchive1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libarchive-dev", ver:"1.2.53-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bsdtar", ver:"1.2.53-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarchive1", ver:"1.2.53-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
