# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 140-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53405);
 script_version ("$");
 name = "Debian Security Advisory DSA 140-2 (libpng, libpng3)";
 script_name(name);

 desc = "The remote host is missing an update to libpng, libpng3
announced via advisory DSA 140-2.

In addition to the advisory DSA 140-1 the packages below fix another
potential buffer overflow.  The PNG libraries implement a safety
margin which is also included in a newer upstream release.  Thanks to
Glenn Randers-Pehrson for informing us.

This problem has been fixed in version 1.0.12-3.woody.2 of libpng and
version 1.2.1-1.1.woody.2 of libpng3 for the current stable
distribution (woody).

We recommend that you upgrade your libpng packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20140-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 140-2 (libpng, libpng3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpng-dev", ver:"1.2.1-1.1.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2", ver:"1.0.12-3.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2-dev", ver:"1.0.12-3.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.1-1.1.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
