# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1395-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58694);
 script_cve_id("CVE-2007-3919");
 script_version ("$");
 name = "Debian Security Advisory DSA 1395-1 (xen-utils)";
 script_name(name);

 desc = "The remote host is missing an update to xen-utils
announced via advisory DSA 1395-1.


Steve Kemp from the Debian Security Audit project discovered that xen-utils,
a collection of XEN administrative tools, used temporary files insecurely
within the xenmon tool allowing local users to truncate arbitrary files.

For the stable distribution (etch) this problem has been fixed in version
3.0.3-0-4.

For the old stable distribution (sarge) this package was not present.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your xen-3.0 (3.0.3-0-4) package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201395-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1395-1 (xen-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xen-docs-3.0", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-utils-3.0.3-1", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-hypervisor-3.0.3-1-amd64", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-ioemu-3.0.3-1", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-hypervisor-3.0.3-1-i386", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-hypervisor-3.0.3-1-i386-pae", ver:"3.0.3-0-4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
