# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1335-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58467);
 script_cve_id("CVE-2006-4519", "CVE-2007-2949");
 script_version ("$");
 name = "Debian Security Advisory DSA 1335-1 (gimp)";
 script_name(name);

 desc = "The remote host is missing an update to gimp
announced via advisory DSA 1335-1.

Several remote vulnerabilities have been discovered in Gimp, the GNU Image
Manipulation Program, which might lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-4519

Sean Larsson discovered several integer overflows in the processing
code for DICOM, PNM, PSD, RAS, XBM and XWD images, which might lead
to the execution of arbitrary code if a user is tricked into opening
such a malformed media file.

CVE-2007-2949

Stefan Cornelius discovered an integer overflow in the processing
code for PSD images, which might lead to the execution of arbitrary
code if a user is tricked into opening such a malformed media file.

For the oldstable distribution (sarge) these problems have been fixed in
version 2.2.6-1sarge4. Packages for mips and mipsel are not yet
available.

For the stable distribution (etch) these problems have been fixed
in version 2.2.13-1etch4. Packages for mips are not yet available.

For the unstable distribution (sid) these problems have been fixed in
version 2.2.17-1.

We recommend that you upgrade your gimp packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201335-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1335-1 (gimp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gimp-data", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp1.2", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-helpbrowser", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-python", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-svg", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.2.6-1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-data", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-helpbrowser", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-python", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-svg", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.2.13-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
