# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1332-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58453);
 script_cve_id("CVE-2007-3316", "CVE-2007-3467", "CVE-2007-3468");
 script_version ("$");
 name = "Debian Security Advisory DSA 1332-1 (vlc)";
 script_name(name);

 desc = "The remote host is missing an update to vlc
announced via advisory DSA 1332-1.

Several remote vulnerabilities have been discovered in the VideoLan
multimedia player and streamer, which may lead to the execution of
arbitrary code. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-3316

David Thiel discovered that several format string vulnerabilities may
lead to the execution of arbitrary code.

CVE-2007-3467

David Thiel discovered an integer overflow in the WAV processing code.

This update also fixes several crashes, which can be triggered through
malformed media files.

For the oldstable distribution (sarge) these problems have been fixed in
version 0.8.1.svn20050314-1sarge3. Packages for the powerpc architecture
are not yet available. They will be provided later.

For the stable distribution (etch) these problems have been fixed
in version 0.8.6-svn20061012.debian-5etch1.

For the unstable distribution (sid) these problems have been fixed in
version 0.8.6.c-1.

We recommend that you upgrade your vlc packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201332-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1332-1 (vlc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnome-vlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gvlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvlc0-dev", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-plugin-vlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qvlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-alsa", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-esd", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-ggi", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-gnome", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-gtk", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-alsa", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-arts", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-esd", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-ggi", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-sdl", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-qt", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-sdl", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wxvlc", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-glide", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-glide", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-svgalib", ver:"0.8.1.svn20050314-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-alsa", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wxvlc", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvlc0", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvlc0-dev", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-plugin-vlc", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-nox", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-arts", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-esd", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-ggi", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-sdl", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-glide", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-svgalib", ver:"0.8.6-svn20061012.debian-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
