# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1322-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58444);
 script_cve_id("CVE-2007-3390", "CVE-2007-3392", "CVE-2007-3393");
 script_version ("$");
 name = "Debian Security Advisory DSA 1322-1 (wireshark)";
 script_name(name);

 desc = "The remote host is missing an update to wireshark
announced via advisory DSA 1322-1.

Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to denial of service. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-3390

Off-by-one overflows were discovered in the iSeries dissector.

CVE-2007-3392

The MMS and SSL dissectors could be forced into an infinite loop.

CVE-2007-3393

An off-by-one overflow was discovered in the DHCP/BOOTP dissector.

The oldstable distribution (sarge) is not affected by these problems.
(In Sarge Wireshark used to be called Ethereal).

For the stable distribution (etch) these problems have been fixed
in version 0.99.4-5.etch.0. Packages for the big endian MIPS architecture
are not yet available. They will be provided later.

For the unstable distribution (sid) these problems have been fixed in
version 0.99.6pre1-1.

We recommend that you upgrade your Wireshark packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201322-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1322-1 (wireshark)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-dev", ver:"0.99.4-5.etch.0", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
