# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1309-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58358);
 script_cve_id("CVE-2007-2138");
 script_version ("$");
 name = "Debian Security Advisory DSA 1309-1 (postgresql-8.1)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql-8.1
announced via advisory DSA 1309-1.

It was discovered that the PostgreSQL database performs insufficient
validation of variables passed to privileged SQL statements, so called
security definers, which could lead to SQL privilege escalation.

The oldstable distribution (sarge) doesn't contain PostgreSQL 8.1.

For the stable distribution (etch) this problem has been fixed in
version 8.1.9-0etch1.

For the unstable distribution (sid) this problem has been fixed in
version 8.1.9-1.

We recommend that you upgrade your PostgreSQL packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201309-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1309-1 (postgresql-8.1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq4", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.1", ver:"8.1.9-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
