# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1261-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58016);
 script_cve_id("CVE-2007-0555");
 script_version ("$");
 name = "Debian Security Advisory DSA 1261-1 (postgresql)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql
announced via advisory DSA 1261-1.

It was discovered that the PostgreSQL database performs insufficient type
checking for SQL function arguments, which might lead to denial of service
or information disclosure.

For the stable distribution (sarge) this problem has been fixed in
version 7.4.7-6sarge4.

For the upcoming stable distribution (etch) this problem has been
fixed in version 8.1.7-1 of the postgresql-8.1 package.

For the unstable distribution (sid) this problem has been fixed in
version 8.1.7-1 of the postgresql-8.1 package.

We recommend that you upgrade your PostgreSQL packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201261-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1261-1 (postgresql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg4", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl-dev", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq3", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"7.4.7-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
