# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1247-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57788);
 script_cve_id("CVE-2006-5989");
 script_bugtraq_id(21214);
 script_version ("$");
 name = "Debian Security Advisory DSA 1247-1 (libapache-mod-auth-kerb)";
 script_name(name);

 desc = "The remote host is missing an update to libapache-mod-auth-kerb
announced via advisory DSA 1247-1.

An off-by-one error leading to a heap-based buffer overflow has been
identified in libapache-mod-auth-kerb, an Apache module for Kerberos
authentication.  The error could allow an attacker to trigger an
application crash or potentially execute arbitrary code by sending a
specially crafted kerberos message.

For the stable distribution (sarge), this problem has been fixed in
version 4.996-5.0-rc6-1sarge1.

For the unstable version (sid) and the forthcoming stable version
(etch), this problem has been fixed in version 5.3-1.

We recommend that you upgrade your libapache-mod-auth-kerb package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201247-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1247-1 (libapache-mod-auth-kerb)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache2-mod-auth-kerb", ver:"4.996-5.0-rc6-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-auth-kerb", ver:"4.996-5.0-rc6-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
