# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1242-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57750);
 script_cve_id("CVE-2006-5063", "CVE-2006-5790", "CVE-2006-5791", "CVE-2006-6318");
 script_version ("$");
 name = "Debian Security Advisory DSA 1242-1 (elog)";
 script_name(name);

 desc = "The remote host is missing an update to elog
announced via advisory DSA 1242-1.

Several remote vulnerabilities have been discovered in elog, a web-based
electronic logbook, which may lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-5063

Tilman Koschnick discovered that log entry editing in HTML is vulnerable
to cross-site scripting. This update disables the vulnerable code.

CVE-2006-5790

Ulf Harnhammar of the Debian Security Audit Project discovered several
format string vulnerabilities in elog, which may lead to execution of
arbitrary code.

CVE-2006-5791

Ulf Harnhammar of the Debian Security Audit Project discovered
cross-site scripting vulnerabilities in the creation of new logbook
entries.

CVE-2006-6318

Jayesh KS and Arun Kethipelly of OS2A discovered that elog performs
insufficient error handling in config file parsing, which may lead to
denial of service through a NULL pointer dereference.

For the stable distribution (sarge) these problems have been fixed in
version 2.5.7+r1558-4+sarge3.

The upcoming stable distribution (etch) will no longer include elog.

For the unstable distribution (sid) these problems have been fixed in
version 2.6.2+r1754-1.

We recommend that you upgrade your elog package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201242-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1242-1 (elog)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"elog", ver:"2.5.7+r1558-4+sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
