# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1212-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57585);
 script_cve_id("CVE-2006-4924", "CVE-2006-5051");
 script_bugtraq_id(20216,20241);
 script_version ("$");
 name = "Debian Security Advisory DSA 1212-1 (openssh (1:3.8.1p1-8.sarge.6))";
 script_name(name);

 desc = "The remote host is missing an update to openssh (1:3.8.1p1-8.sarge.6)
announced via advisory DSA 1212-1.

Two denial of service vulnerabilities have been found in the OpenSSH
server.

CVE-2006-4924
The sshd support for ssh protcol version 1 does not properly
handle duplicate incoming blocks.  This could allow a remote
attacker to cause sshd to consume significant CPU resources
leading to a denial of service.

CVE-2006-5051
A signal handler race condition could potentially allow a remote
attacker to crash sshd and could theoretically lead to the
ability to execute arbitrary code.

For the stable distribution (sarge), these problems have been fixed in
version 1:3.8.1p1-8.sarge.6

For the unstable and testing distributions, these problems have been
fixed in version 1:4.3p2-4

We recommend that you upgrade your openssh package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201212-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1212-1 (openssh (1:3.8.1p1-8.sarge.6))";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"3.8.1p1-8.sarge.6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh", ver:"3.8.1p1-8.sarge.6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
