# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1211-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57584);
 script_cve_id("CVE-2006-4251");
 script_version ("$");
 name = "Debian Security Advisory DSA 1211-1 (pdns)";
 script_name(name);

 desc = "The remote host is missing an update to pdns
announced via advisory DSA 1211-1.

It was discovered that malformed TCP packets may lead to denial of service
and possibly the execution of arbitrary code if the PowerDNS nameserver
acts as a recursive nameserver.

For the stable distribution (sarge) this problem has been fixed in
version 2.9.17-13sarge3.

For the upcoming stable distribution (etch) this problem has been fixed
in version 3.1.4-1 of pdns-recursor.

For the unstable distribution (sid) this problem has been fixed in
version 3.1.4-1 of pdns-recursor.

We recommend that you upgrade your PowerDNS packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201211-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1211-1 (pdns)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pdns-doc", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-geo", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-ldap", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-mysql", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-pgsql", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-pipe", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-sqlite", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-recursor", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-server", ver:"2.9.17-13sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
