# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1185-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57481);
 script_cve_id("CVE-2006-2940");
 script_version ("$");
 name = "Debian Security Advisory DSA 1185-2 (openssl)";
 script_name(name);

 desc = "The remote host is missing an update to openssl
announced via advisory DSA 1185-2.

The fix used to correct CVE-2006-2940 introduced code that could lead to
the use of uninitialized memory.  Such use is likely to cause the
application using the openssl library to crash, and has the potential to
allow an attacker to cause the execution of arbitrary code.

For the stable distribution (sarge) these problems have been fixed in
version 0.9.7e-3sarge4.

For the unstable and testing distributions (sid and etch,
respectively), these problems will be fixed in version 0.9.7k-3 of the
openssl097 compatibility libraries, and version 0.9.8c-3 of the
openssl package.

We recommend that you upgrade your openssl package.  Note that

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201185-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1185-2 (openssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.7e-3sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7e-3sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.7e-3sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
