# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1152-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57296);
 script_cve_id("CVE-2006-3695");
 script_version ("$");
 name = "Debian Security Advisory DSA 1152-1 (trac)";
 script_name(name);

 desc = "The remote host is missing an update to trac
announced via advisory DSA 1152-1.

Felix Wiemann discovered that trac, an enhanced Wiki and issue
tracking system for software development projects, can be used to
disclose arbitrary local files.  To fix this problem, python-docutils
needs to be updated as well.

For the stable distribution (sarge) this problem has been fixed in
version 0.8.1-3sarge5 of trac and version 0.3.7-2sarge1 of
python-docutils.

For the unstable distribution (sid) this problem has been fixed in
version 0.9.6-1.

We recommend that you upgrade your trac and python-docutils packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201152-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1152-1 (trac)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-docutils", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-roman", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-difflib", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-textwrap", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-docutils", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-textwrap", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-docutils", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-docutils", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"trac", ver:"0.8.1-3sarge5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
