# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1139-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57208);
 script_cve_id("CVE-2006-3694");
 script_version ("$");
 name = "Debian Security Advisory DSA 1139-1 (ruby1.6)";
 script_name(name);

 desc = "The remote host is missing an update to ruby1.6
announced via advisory DSA 1139-1.

It was discovered that the interpreter for the Ruby language does not
properly maintain safe levels for aliasing, directory accesses and
regular expressions, which might lead to a bypass of security
restrictions.

For the stable distribution (sarge) this problem has been fixed in
version 1.6.8-12sarge2.

The unstable distribution (sid) does no longer contain ruby1.6 packages.

We recommend that you upgrade your Ruby packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201139-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1139-1 (ruby1.6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"irb1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.6-elisp", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.6-examples", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurses-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpty-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.6-dbg", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsdbm-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsyslog-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtk-ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.6", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.6-dev", ver:"1.6.8-12sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
