# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1133-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57202);
 script_cve_id("CVE-2006-0664", "CVE-2006-0665", "CVE-2006-0841", "CVE-2006-1577");
 script_version ("$");
 name = "Debian Security Advisory DSA 1133-1 (mantis)";
 script_name(name);

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 1133-1.

Several remote vulnerabilities have been discovered in the Mantis bug
tracking system, which may lead to the execution of arbitrary web script.
The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-0664

A cross-site scripting vulnerability was discovered in
config_defaults_inc.php.

CVE-2006-0665

Cross-site scripting vulnerabilities were discovered in query_store.php
and manage_proj_create.php.

CVE-2006-0841

Multiple cross-site scripting vulnerabilities were discovered in
view_all_set.php, manage_user_page.php, view_filters_page.php and
proj_doc_delete.php.

CVE-2006-1577

Multiple cross-site scripting vulnerabilities were discovered in
view_all_set.php.

For the stable distribution (sarge) these problems have been fixed in
version 0.19.2-5sarge4.1.

For the unstable distribution (sid) these problems have been fixed in
version 0.19.4-3.1.

We recommend that you upgrade your mantis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201133-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1133-1 (mantis)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"0.19.2-5sarge4.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
