# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 109-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53390);
 script_version ("$");
 name = "Debian Security Advisory DSA 109-1 (faqomatic)";
 script_name(name);

 desc = "The remote host is missing an update to faqomatic
announced via advisory DSA 109-1.

Due to unescaped HTML code Faq-O-Matic returned unverified scripting
code to the browser.  With some tweaking this enables an attacker to
steal cookies from one of the Faq-O-Matic moderators or the admin.

Cross-Site Scripting is a type of problem that allows a malicious
person to make another person run some JavaScript in their browser.
The JavaScript is executed on the victims machine and is in the
context of the website running the Faq-O-Matic Frequently Asked
Question manager.

This problem has been fixed in version 2.603-1.2 for the stable Debian
distribution and version 2.712-2 for the current testing/unstable
distribution.

We recommend that you upgrade your faqomatic package if you have it


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20109-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 109-1 (faqomatic)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"faqomatic", ver:"2.603-1.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
