# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1065-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56783);
 script_bugtraq_id(17846);
 script_cve_id("CVE-2006-2213");
 script_version ("$");
 name = "Debian Security Advisory DSA 1065-1 (hostapd)";
 script_name(name);

 desc = "The remote host is missing an update to hostapd
announced via advisory DSA 1065-1.

Matteo Rosi and Leonardo Maccari discovered that hostapd, a wifi network
authenticator daemon, performs insufficient boundary checks on a key length
value, which might be exploited to crash the service.

The old stable distribution (woody) does not contain hostapd packages.

For the stable distribution (sarge) this problem has been fixed in
version 0.3.7-2sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 0.5-1.

We recommend that you upgrade your hostapd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201065-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1065-1 (hostapd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hostapd", ver:"0.3.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
