# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1059-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56777);
 script_cve_id("CVE-2006-2223", "CVE-2006-2224", "CVE-2006-2276");
 script_bugtraq_id(17808);
 script_version ("$");
 name = "Debian Security Advisory DSA 1059-1 (quagga)";
 script_name(name);

 desc = "The remote host is missing an update to quagga
announced via advisory DSA 1059-1.

Konstantin Gavrilenko discovered several vulnerabilities in quagga,
the BGP/OSPF/RIP routing daemon.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2006-2223

Remote attackers may obtain sensitive information via RIPv1
REQUEST packets even if the quagga has been configured to use MD5
authentication.

CVE-2006-2224

Remote attackers could inject arbitrary routes using the RIPv1
RESPONSE packet even if the quagga has been configured to use MD5
authentication.

CVE-2006-2276

Fredrik Widell discovered that local users are can cause a denial
of service ia a certain sh ip bgp command entered in the telnet
interface.

The old stable distribution (woody) does not contain quagga packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.98.3-7.2.

For the unstable distribution (sid) these problems have been fixed in
version 0.99.4-1.

We recommend that you upgrade your quagga package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201059-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1059-1 (quagga)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.98.3-7.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.98.3-7.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
