# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1026-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56537);
 script_cve_id("CVE-2005-1849", "CVE-2005-2096");
 script_version ("$");
 name = "Debian Security Advisory DSA 1026-1 (sash)";
 script_name(name);

 desc = "The remote host is missing an update to sash
announced via advisory DSA 1026-1.

Markus Oberhumer discovered a flaw in the way zlib, a library used for
file compression and decompression, handles invalid input. This flaw can
cause programs which use zlib to crash when opening an invalid file.
A further error in the way zlib handles the inflation of certain
compressed files can cause a program which uses zlib to crash when opening
an invalid file.

sash, the stand-alone shell, links statically against zlib, and was
thus affected by these problems.

The old stable distribution (woody) isn't affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 3.7-5sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 3.7-6.

We recommend that you upgrade your sash package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201026-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1026-1 (sash)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sash", ver:"3.7-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
