# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1002-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56410);
 script_cve_id("CVE-2005-3949", "CVE-2005-3961", "CVE-2005-3982");
 script_bugtraq_id(15606,15608,15662,15673);
 script_version ("$");
 name = "Debian Security Advisory DSA 1002-1 (webcalendar)";
 script_name(name);

 desc = "The remote host is missing an update to webcalendar
announced via advisory DSA 1002-1.

Several security related problems have been discovered in webcalendar,
a PHP based multi-user calendar.  The Common Vulnerabilities and
Exposures project identifies the following vulnerabilities:

CVE-2005-3949

Multiple SQL injection vulnerabilities allow remote attackers to
execute arbitrary SQL commands.

CVE-2005-3961

Missing input sanitising allowas an attacker to overwrite local
files.

CVE-2005-3982

A CRLF injection vulnerability allows remote attackers to modify
HTTP headers and conduct HTTP response splitting attacks.

The old stable distribution (woody) does not contain webcalendar packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.9.45-4sarge3.

For the unstable distribution (sid) these problems have been fixed in
version 1.0.2-1.

We recommend that you upgrade your webcalendar package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201002-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1002-1 (webcalendar)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"webcalendar", ver:"0.9.45-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
