# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 089-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53829);
 script_version ("$");
 name = "Debian Security Advisory DSA 089-1 (icecast-server)";
 script_name(name);

 desc = "The remote host is missing an update to icecast-server
announced via advisory DSA 089-1.

The icecast-server (a streaming music server) package as distributed
in Debian GNU/Linux 2.2 has several security problems:

* if a client added a / after the filename of a file to be downloaded
the server would crash
* by escaping dots as %2E it was possible to circumvent security measures
and download arbitrary files
* there were several buffer overflows that could be exploited to
gain root access

These have been fixed in version 1.3.10-1, and we strongly recommend
that you upgrade your icecast-server package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20089-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 089-1 (icecast-server)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"icecast-server", ver:"1.3.10-1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
