# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 085-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53765);
 script_version ("$");
 name = "Debian Security Advisory DSA 085-1 (nvi, nvi-m17n)";
 script_name(name);

 desc = "The remote host is missing an update to nvi, nvi-m17n
announced via advisory DSA 085-1.

Takeshi Uno found a very stupid format string vulnerability in all
versions of nvi (in both, the plain and the multilingualized version).
When a filename is saved, it ought to get displayed on the screen.
The routine handling this didn't escape format strings.

This problem has been fixed in version 1.79-16a.1 for nvi and
1.79+19991117-2.3 for nvi-m17n for the stable Debian GNU/Linux 2.2.

Even if we don't believe that this could lead into somebody gaining
access of another users account if he hasn't lost his brain, we
recommend that you upgrade your nvi packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20085-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 085-1 (nvi, nvi-m17n)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nvi-m17n-common", ver:"1.79+19991117-2.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvi-m17n-canna", ver:"1.79+19991117-2.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvi-m17n", ver:"1.79+19991117-2.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvi", ver:"1.79-16a.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
