# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 082-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53572);
 script_version ("$");
 name = "Debian Security Advisory DSA 082-1 (xvt)";
 script_name(name);

 desc = "The remote host is missing an update to xvt
announced via advisory DSA 082-1.

Christophe Bailleux reported on bugtraq that Xvt is vulnerable to a
buffer overflow in its argument handling.  Since Xvt is installed
setuid root, it was possible for a normal user to pass
carefully-crafted arguments to xvt so that xvt executed a root shell.

This problem has been fixed by the maintainer in version 2.1-13 of xvt
for Debian unstable and 2.1-13.0potato.1 for the stable Debian
GNU/Linux 2.2.

We recommend that you upgrade your xvt package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20082-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 082-1 (xvt)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xvt", ver:"2.1-13.0potato.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
