# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 061-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53814);
 script_version ("$");
 name = "Debian Security Advisory DSA 061-1 (gnupg)";
 script_name(name);

 desc = "The remote host is missing an update to gnupg
announced via advisory DSA 061-1.

The version of GnuPG (GNU Privacy Guard, an OpenPGP implementation)
as distributed in Debian GNU/Linux 2.2 suffers from two problems:

fish stiqz reported on bugtraq that there was a printf format
problem in the do_get() function: it printed a prompt which included
the filename that was being decrypted without checking for
possible printf format attacks. This could be exploited by tricking
someone into decrypting a file with a specially crafted filename.

The second bug is related to importing secret keys: when gnupg
imported a secret key it would immediately make the associated
public key fully trusted which changes your web of trust without
asking for a confirmation. To fix this you now need a special
option to import a secret key.

Both problems have been fixed in version 1.0.6-0potato1.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20061-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 061-1 (gnupg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnupg", ver:"1.0.6-0potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
