# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 059-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53812);
 script_version ("$");
 name = "Debian Security Advisory DSA 059-1 (man-db)";
 script_name(name);

 desc = "The remote host is missing an update to man-db
announced via advisory DSA 059-1.

Luki R. reported a bug in man-db: it did handle nested calls of
drop_effective_privs() and regain_effective_privs() correctly which
would cause it to regain privileges to early. This could be abused
to make man create files as user man.

This has been fixed in version 2.3.16-4, and we recommend that you
upgrade your man-db package immediately. If you use suidmanager you
can also use that to make sure man and mandb are not installed suid
which protects you from this problem. This can be done with the
following commands:

suidregister /usr/lib/man-db/man root root 0755
suidregister /usr/lib/man-db/mandb root root 0755

Of course even when using suidmanager an upgrade is still strongly
recommended.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20059-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 059-1 (man-db)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"man-db", ver:"2.3.16-4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
