# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 037-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53799);
 script_version ("$");
 name = "Debian Security Advisory DSA 037-1 (nextaw, xaw3d, xaw95)";
 script_name(name);

 desc = "The remote host is missing an update to nextaw, xaw3d, xaw95
announced via advisory DSA 037-1.

It has been reported that the AsciiSrc and MultiSrc widget in the
Athena widget library handle temporary files insecurely.  Joey Hess
has ported the bugfix from XFree86 to these Xaw replacements
libraries.

We recommend you upgrade your nextaw, xaw3d and xaw95 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20037-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 037-1 (nextaw, xaw3d, xaw95)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nextaw", ver:"0.5.1-34potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nextawg", ver:"0.5.1-34potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xaw3d", ver:"1.3-6.9potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xaw3dg-dev", ver:"1.3-6.9potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xaw3dg", ver:"1.3-6.9potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xaw95g", ver:"1.1-4.6potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
