# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 032-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53794);
 script_version ("$");
 name = "Debian Security Advisory DSA 032-1 (proftpd)";
 script_name(name);

 desc = "The remote host is missing an update to proftpd
announced via advisory DSA 032-1.

The following problems have been reported for the version of proftpd in
Debian 2.2 (potato):

1. There is a configuration error in the postinst script, when the user
enters 'yes', when asked if anonymous access should be enabled.
The postinst script wrongly leaves the 'run as uid/gid root' configuration
option in /etc/proftpd.conf, and adds a 'run as uid/gid nobody' option that
has no effect.

2. There is a bug that comes up when /var is a symlink, and proftpd is
restarted. When stopping proftpd, the /var symlink is removed; when it's
started again a file named /var is created.

The above problems have been corrected in proftpd-1.2.0pre10-2.0potato1.
We recommend you upgrade your proftpd package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20032-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 032-1 (proftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd", ver:"1.2.0pre10-2.0potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
