# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 026-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53789);
 script_version ("$");
 name = "Debian Security Advisory DSA 026-1 (bind)";
 script_name(name);

 desc = "The remote host is missing an update to bind
announced via advisory DSA 026-1.

BIND 8 suffered from several buffer overflows.  It is possible to
construct an inverse query that allows the stack to be read remotely
exposing environment variables.  CERT has disclosed information about
these issues.  A new upstream version fixes this.  Due to the
complexity of BIND we have decided to make an exception to our rule by
releasin the new upstream source to our stable distribution.

We recommend you upgrade your bind packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20026-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 026-1 (bind)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bind-dev", ver:"8.2.3-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind", ver:"8.2.3-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"8.2.3-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind-doc", ver:"8.2.3-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"task-dns-server", ver:"8.2.3-0.potato.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
