#
# GPL licensed by Tenable and distributed under Tenable GPL feed - 10 July 2006
#

#
# (C) Tenable Network Security
#

if(description)
{
 script_id(19559);
 script_version("$Revision: 5880 $");
 
 name = "CiscoWorks Management Console Detection";

 script_name(name);
 
 desc = "
The remote host appears to be running CiscoWorks, a LAN Management Solution,
on this port

Risk factor : None";

 script_description(desc);
 
 summary = "Checks for CiscoWorks";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2005 TNS");
 
 script_family("Service detection");
 script_dependencie("httpver.nasl");
 script_require_ports("Services/www", 1741);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");


port = get_kb_item("Services/www");
if ( ! port ) port = 1741;

if(get_port_state(port))
{
  req = http_get(item:"/login.html", port:port);
  soc  = open_sock_tcp(port);
  if ( ! soc ) exit(0);
  send(socket:soc, data:req);
  res = http_recv(socket:soc);

  if("<title>CiscoWorks</title>" >< res )
  {
    security_note(port);
    set_kb_item(name:"Services/www/" + port + "/embedded", value:TRUE);
  }
}
