###############################################################################
# OpenVAS Vulnerability Test
# $Id: bugzilla_detect.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Bugzilla Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running Bugzilla a 'Defect Tracking System' or
  'Bug-Tracking System'. Defect Tracking Systems allow individual or
  groups of developers to keep track of outstanding bugs in their
  product effectively.

 See also:
  http://www.bugzilla.org

 Risk factor : None";

if (description)
{
 script_id(100093);
 script_version ("1.0");

 script_name("Bugzilla Detection");  

 script_description(desc);
 script_summary("Checks for the presence of Bugzilla");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

dirs = make_list("/bugzilla","/bugs",cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/index.cgi"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
 if( buf == NULL )continue;

 if(egrep(pattern: "Bugzilla_login", string: buf) && egrep(pattern: "Bugzilla_password", string: buf) )
 { 
     if(strlen(dir)>0) {
        install=dir;
     } else {
        install=string("/");
     }  
    
    vers = string("unknown");

    ### try to get version 

    version = eregmatch(string: buf, pattern: "version ([0-9.]+)",icase:TRUE);
    
    if(isnull(version[1])) { 

      url = string(dir, "/docs/en/txt/Bugzilla-Guide.txt");
      req = http_get(item:url, port:port);
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);

      version = eregmatch(string: buf, pattern: "The Bugzilla Guide - ([0-9.]+) Release");

      if ( !isnull(version[1]) ) {
        vers=version[1];
      } else {
	 
	url = string(dir, "/CVS/Tag");
	req = http_get(item:url, port:port);
	buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);

	if( !isnull(buf)) {
	    
	  version = eregmatch(string: buf, pattern: "BUGZILLA-([0-9._]+).*");

	  if ( !isnull(version[1]) ) {
	    if(version[1] = ereg_replace(pattern:"_", string:version[1], replace:".")) {
	      vers=version[1];
	    }
	  }  
	}  
      }  
    } else {
	vers=version[1];
    }  
    
    set_kb_item(name: string("www/", port, "/bugzilla"), value: string(vers," under ",install));
    set_kb_item(name:string("www/", port, "/bugzilla/version"),value:vers);

    info = string("None\n\nBugzilla Version '");
    info += string(vers);
    info += string("' was detected on the remote host in the following directory(s):\n\n");
    info += string(install, "\n"); 

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );    
       
       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }	 
       exit(0);
  }
}

exit(0);
