###############################################################################
# OpenVAS Vulnerability Test
# $Id: bind_37865.nasl 6639 2010-02-04 11:53:38Z chandra $
#
# ISC BIND 9 DNSSEC Bogus NXDOMAIN Response Remote Cache Poisoning Vulnerability
#
# Authors:
# Michael Meyer
#
# Updated By : Antu Sanadi <santu@secpod.com> 2010-01-129 #6962
# Added the  CVE-2010-0290 and CVE-2010-0382
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100458);
 script_bugtraq_id(37865);
 script_cve_id("CVE-2010-0097", "CVE-2010-0290","CVE-2010-0382");
 script_version ("1.0-$Revision: 6639 $");

 script_name("ISC BIND 9 DNSSEC Bogus NXDOMAIN Response Remote Cache Poisoning Vulnerability");

desc = "Overview:
ISC BIND 9 is prone to a remote cache-poisoning vulnerability.

An attacker may leverage this issue to manipulate cache data,
potentially facilitating man-in-the-middle, site-impersonation, or denial-of-
service attacks.

Versions prior to the following are vulnerable:

BIND 9.4.3-P5 BIND 9.5.2-P2 BIND 9.6.1-P3

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37865
http://www.isc.org/products/BIND/
http://www.kb.cert.org/vuls/id/360341
https://www.isc.org/advisories/CVE-2010-0097

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if BIND 9 is prone to a remote cache-poisoning vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("dns_server.nasl","bind_version.nasl");
 script_require_ports("Services/dns", 53);
 exit(0);
}

include("misc_func.inc");
include("version_func.inc");

if(!get_kb_item("DNS/tcp/53"))exit(0);
if(!version = get_kb_item("bind/version"))exit(0);
version = str_replace(find:"-", string: version, replace:".");

if(version =~ "9\.[0-4]+") {
  if(version_is_less(version: version, test_version: "9.4.3.P5")) {
    VULN = TRUE;
  }
}
else if(version =~ "9\.5") {
  if(version_is_less(version: version, test_version: "9.5.2.P2")) {
    VULN = TRUE;
  }
}
else if(version =~ "9\.6") {
  if(version_is_less(version: version, test_version: "9.6.1.P3")) {
    VULN = TRUE;
  }
}

if(VULN) {
  security_warning(port:53, proto:"udp");
  exit(0);
}

exit(0);
