###############################################################################
# OpenVAS Vulnerability Test
# $Id: barracuda_im_firewall_detect.nasl 6126 2009-12-11 11:55:06Z mime $
#
# Barracuda IM Firewall Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Barracuda IM Firewall. Barracuda IM Firewall
control and manage internal and external instant messaging (IM)
traffic. 

See also:
http://www.barracudanetworks.com/

Risk factor : None";

if (description)
{
 script_id(100392);
 script_version ("1.0-$Revision: 6126 $");

 script_name("Barracuda IM Firewall Detection");
 script_description(desc);
 script_summary("Checks for the presence of Barracuda IM Firewall");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if("Server: BarracudaHTTP" >!< banner)exit(0);

 url = string(dir, "/cgi-mod/index.cgi");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if(egrep(pattern: "<title>Barracuda IM Firewall", string: buf, icase: TRUE)) {

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "barracuda.css\?v=([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
    }

    set_kb_item(name: string("www/", port, "/barracuda_im_firewall"), value: vers);

    info = string("None\n\nBarracuda IM Firewall Version '");
    info += string(vers);
    info += string("' was detected on the remote host.\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

