###############################################################################
# OpenVAS Vulnerability Test
# $Id: asterisk_36924.nasl 5835 2009-11-10 11:45:58Z mime $
#
# Asterisk SIP Response Username Enumeration Remote Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100341);
 script_bugtraq_id(36924);
 script_cve_id("CVE-2009-3727");
 script_version ("1.0-$Revision: 5835 $");

 script_name("Asterisk SIP Response Username Enumeration Remote Information Disclosure Vulnerability");

desc = "Overview:
Asterisk is prone to an information-disclosure vulnerability because
it doesn't provide safe responses to failed authentication attempts.

Attackers can exploit this issue to discover whether specific
usernames exist. Information harvested may aid in launching
further attacks.

Solution:
The vendor has released an advisory and updates. Please see the
references for details.

References:
http://www.securityfocus.com/bid/36924
http://www.asterisk.org/
http://www.securityfocus.com/archive/1/507688
http://downloads.asterisk.org/pub/security/AST-2009-008.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Asterisk is prone to an information-disclosure vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_asterisk_detect.nasl");
 script_require_keys("Services/udp/sip");
 exit(0);
}

include("version_func.inc");

asterisk_port = get_kb_item("Services/udp/sip");
if(!asterisk_port)exit(0);
if(!get_udp_port_state(asterisk_port))exit(0);

asteriskVer = get_kb_item("Asterisk-PBX/Ver");
if(!asteriskVer){
      exit(0);
}

if(version_in_range(version:asteriskVer, test_version:"1.6.1",  test_version2:"1.6.1.8")  ||
   version_in_range(version:asteriskVer, test_version:"1.6",    test_version2:"1.6.16")   ||
   version_in_range(version:asteriskVer, test_version:"1.4.26", test_version2:"1.4.26.2") ||
   version_in_range(version:asteriskVer, test_version:"1.2",    test_version2:"1.2.34")) {

    security_warning(port:asterisk_port, proto:"udp");
    exit(0);

}

exit(0);
