#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10677);
 script_version ("$Revision: 5372 $");
 name = "Apache /server-status accessible";
 
 script_name(name);
 
 desc = "
Requesting the URI /server-status gives information about
the currently running Apache.

Risk factor : Low
Solution : 
If you don't use this feature, comment the appropriate section in
your httpd.conf file. If you really need it, limit its access to
the administrator's machine.";

 script_description(desc);
 
 summary = "Makes a request like http://www.example.com/server-status";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2001 StrongHoldNet");
 family = "General";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/apache");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
str = "Apache Server Status";

if(get_port_state(port))
{
  buffer = http_get(item:"/server-status", port:port);
  data = http_keepalive_send_recv(port:port, data:buffer);
  if( str >< data )
  {
   security_warning(port);
  }
}
