###############################################################################
# OpenVAS Vulnerability Test
# $Id: afian_directory_traversal_vulnerability.nasl 48 2009-03-03 12:28:51Z mime $
#
# Afian 'includer.php' Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100009);
 script_bugtraq_id(33943);
 script_version ("1.0");

 script_name("Afian 'includer.php' Directory Traversal Vulnerability");
 desc = "

 Overview:
  Afian is prone to a directory-traversal vulnerability because it
  fails to sufficiently sanitize user-supplied input data.

  Exploiting the issue may allow an attacker to obtain sensitive
  information that could aid in further attacks. 

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Afian is vulnerable to Local File Include Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/filemanager","/fileserver", cgi_dirs());

foreach d (dir)
{
 
 url = string(d, "/index.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if( buf == NULL )continue;
  
 if(egrep(pattern:"Afian Document Manager - Login", string: buf)) { # is it Afian Document Manager

   url = string(d, "/css/includer.php?files=includer.php");
   req = http_get(item:url, port:port);
   buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
   if( buf == NULL )continue;
   if ( buf =~ "Zend.*" )
     {
      security_warning(port:port);
      exit(0);
   }
  }
}
exit(0);
