###############################################################################
# OpenVAS Vulnerability Test
# $Id: TinyWebGallery_34892.nasl 6984 2010-03-17 12:20:23Z mime $
#
# TinyWebGallery/QuiXplorer Local File Include Vulnerability
#
# Authors
# Michael Meyer
#
# Updated to  check individual Vulnerability for QuiXplorer
#  -By Antu Sanadi <santu@secpod.com> on 2009-06-09
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
  script_id(100193);
  script_cve_id("CVE-2009-1911");
  script_bugtraq_id(34892);
  script_version ("1.1");
  script_name("TinyWebGallery/QuiXplorer Local File Include Vulnerability");
  desc = "

 Overview:
  TinyWebGallery and QuiXplorer are prone to a local file-include vulnerability
  because it fails to properly sanitize user-supplied input.

  An attacker can exploit this vulnerability to view files and execute
  local scripts in the context of the webserver process. This may aid
  in further attacks.

  TinyWebGallery 1.7.6 and prior versions are vulnerable.
  QuiXplorer 2.3.2 and prior versions are vulnerable.

 Solution:
  An update is available. Please see http://www.tinywebgallery.com
  for more information.

 See also:
  http://www.securityfocus.com/bid/34892
  http://www.tinywebgallery.com/forum/viewtopic.php?t=1653

 Risk factor : High";

 script_description(desc);
 script_summary("Determine if TinyWebGallery is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("TinyWebGallery_detect.nasl","gb_quixplorer_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

version = get_kb_item(string("www/", port, "/TinyWebGallery"));
if(version != NULL)
{
  matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$");
  vers = matches[1];
  if(!isnull(vers) && vers >!< "unknown")
  {
    if(version_is_less_equal(version: vers, test_version: "1.7.6"))
    {
     security_hole(port:port);
     exit(0);
    }
  }
}

quixplorerVer = get_kb_item(string("www/", port, "/QuiXplorer"));
if(quixplorerVer != NULL)
{
  qxplorerVer = eregmatch(string:quixplorerVer, pattern:"^(.+) under (/.*)$");
  if(version_is_less_equal(version: qxplorerVer[1], test_version:"2.3.2")){
   security_hole(port:port);
  }
}

exit(0);
