###############################################################################
# OpenVAS Vulnerability Test
# $Id: TYPSoft_ftp_server_34901.nasl 6984 2010-03-17 12:20:23Z mime $
#
# TYPSoft FTP Server 'ABORT' Command Remote Denial of Service
# Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(100198);
  script_bugtraq_id(34901);
  script_version("1.0");

  desc = "
  Overview:

   TYPSoft FTP Server is prone to a remote denial-of-service
   vulnerability.

   This issue allows remote attackers to cause the affected server to
   stop responding, denying service to legitimate users.

   TYPSoft FTP Server 1.11 is vulnerable; other versions may also be
   affected. 

  See also:
   http://www.securityfocus.com/bid/34901

  Risk factor : Medium";

  script_name("TYPSoft FTP Server 'ABORT' Command Remote Denial of Service Vulnerability");
  script_description(desc);
  script_summary("Determine if TYPSoft FTP Server Version <= 1.11");
  
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("FTP");
  script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
  script_require_ports("Services/ftp", 21);
  exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(port)){
  exit(0);
}

if( ! banner = get_ftp_banner(port) ) exit(0);
if( ! egrep(pattern:"TYPSoft FTP Server", string: banner) )exit(0);

version = eregmatch(pattern:"TYPSoft FTP Server ([0-9.]+)", string: banner);

if( ! isnull(version[1]) ) {

    if( version_is_less_equal(version:version[1], test_version:"1.11") ) {
	security_warning(port: port);
	exit(0);

    }  
}  

exit(0);
