###############################################################################
# OpenVAS Vulnerability Test
# $Id: Cryptographp_local_file_include.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Cryptographp 'index.php' Local File Include Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100060);
 script_bugtraq_id(34122);
 script_version ("1.0");

 script_name("Cryptographp 'index.php' Local File Include Vulnerability");
 desc = "

 Overview:
  Cryptographp is prone to a local file-include vulnerability because
  it fails to properly sanitize user-supplied input.

  An attacker can exploit this vulnerability to view files and execute
  local scripts from the Cryptographp directory in the context of the
  webserver process. This may aid in further attacks.

  Cryptographp 1.4 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34122

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cryptographp is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/crypt");

foreach d (dir)
{ 
 req = string("GET ", d, "/cryptographp.inc.php?cfg=verifier.php&sn=PHPSESSID& HTTP/1.1\r\n",
              "Host: ", get_host_name(), ":", port, "\r\n",
              "User-Agent: Mozilla/5.0 (OpenVAS; U; Linux i686; en-US; rv:1.7) Gecko/20040712", 
              "Accept-Language: en-us,en,de;\r\n",
              "Cookie: cryptcookietest=1\r\n",
              "Connection: close\r\n\r\n");

 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:0);
 if( buf == NULL )continue;

 if ( egrep(pattern:".*Cannot redeclare.*", string: buf) )
 	{    
	  security_warning(port:port);
          exit(0);
        } 
}

exit(0);
