###############################################################################
# OpenVAS Vulnerability Test
# $Id: CoreHTTP_37454.nasl 6306 2010-01-04 17:09:12Z mime $
#
# CoreHTTP CGI Support Remote Command Execution Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100418);
 script_bugtraq_id(37454);
 script_version ("1.0-$Revision: 6306 $");

 script_name("CoreHTTP CGI Support Remote Command Execution Vulnerability");

desc = "Overview:
CoreHTTP is prone to a remote command-execution vulnerability because
the software fails to adequately sanitize user-supplied input.

Successful attacks can compromise the affected software and possibly
the computer.

CoreHTTP 0.5.3.1 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/37454
http://corehttp.sourceforge.net/
http://aconole.brad-x.com/advisories/corehttp.txt

Risk factor : High";

 script_description(desc);
 script_summary("Determine if CoreHTTP version is 0.5.3.1");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 5555);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:5555);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if(egrep(pattern:"Server: corehttp", string:banner)) {
  version = eregmatch(pattern: "Server: corehttp-([0-9.]+)", string: banner);
  if(!isnull(version[1])) {
    if(version_is_equal(version: version[1], test_version: "0.5.3.1")) {
      security_hole(port:port);
      exit(0);
    }  
  }  
}

exit(0);
