###############################################################################
# OpenVAS Vulnerability Test
# $Id: BigAnt_detect.nasl 5349 2009-10-01 16:57:31Z mime $
#
# BigAnt IM Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100280);
 script_version ("1.0-$Revision: 5349 $");

 script_name("BigAnt IM Server Detection");

 desc = "Overview:
This host is running BigAnt IM Server, a instant messaging solution
for enterprise.

See also:
http://www.bigantsoft.com/

Risk factor : None";

 script_description(desc);
 script_summary("Checks for the presence of BigAnt IM Server");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 exit(0);
}

include("http_func.inc");
include("global_settings.inc");
include("misc_func.inc");

port = get_http_port(default:6660);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if(egrep(pattern:"AntServer", string:banner))
 {
  register_service(port:port, ipproto:"tcp", proto:"BigAnt");
  if(report_verbosity > 0) {
   security_note(port:port);
  }
 }

exit(0);

